define(['angular', 'angularMocks', 'app', 'TwoPanelController', 'angularUiRouter', 'Modernizr'], function(angular, mocks, app) {
    'use strict';

    describe('The Two-Column controller', function () {

        var controller,
            rootScope,
            scope,
            state,
            focusServiceMock,
            pageServiceMock,
            globalDelayTrackerMock;

        beforeEach( function () {
            module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain', 'focusPrimary', 'focusSecondary']);
            pageServiceMock = jasmine.createSpyObj('pageService', ['responsive', 'exitPrimaryContent', 'globalDelayTracker']);
            globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['active']);

            module(function($provide){
                $provide.value('focusService', focusServiceMock);
                $provide.value('pageService', pageServiceMock);
                $provide.value('globalDelayTracker', globalDelayTrackerMock);
            });

            inject(function ($controller, $rootScope, $state, $q) {
                rootScope = $rootScope;
                scope = rootScope.$new();
                state = $state;
                state.current.data = {};
                spyOn(scope, '$on').andCallThrough();
                controller = $controller('TwoPanelController', {$scope: scope, $state: state});
            });
        });

        it("should default secondaryPanelWidth to 'standard'", function(){
            expect(scope.secondaryPanelWidth).toEqual('standard');
        });

        it("should have a function resolutionWidth()", function(){
            expect(typeof scope.resolutionWidth).toEqual('function');
            expect(typeof scope.resolutionWidth()).toEqual('boolean');
        });

        describe("when view content has loaded with data giving secondary panel focus", function(){
            beforeEach(function(){
                state.current.data = {
                    panel: 'secondary'
                };
                scope.$root.$digest();
                scope.$broadcast('$viewContentLoaded');
            });

            it("should focus on secondary panel header and update the pageService.responsive flag", function() {
                expect(focusServiceMock.focusSecondary).toHaveBeenCalled();
                expect(pageServiceMock.responsive.primary).toEqual("0");
            });
        });

        describe("when view content has loaded with data giving primary panel focus", function(){
            beforeEach(function(){
                state.current.data = {
                    panel: 'primary'
                };
                scope.$root.$digest();
                scope.$broadcast('$viewContentLoaded');
            });

            it("should focus on primary panel header and update the pageService.responsive flag", function() {
                expect(focusServiceMock.focusPrimary).toHaveBeenCalled();
                expect(pageServiceMock.responsive.primary).toEqual("1");
            });
        });

        describe("when state changes with data giving secondary panel focus", function(){
            beforeEach(function(){
                state.current.data = {
                    panel: 'secondary'
                };
                scope.$root.$digest();
                scope.$broadcast('$stateChangeSuccess');
            });

            it("should focus on secondary panel header and update the pageService.responsive flag", function() {
                expect(focusServiceMock.focusSecondary).toHaveBeenCalled();
                expect(pageServiceMock.responsive.primary).toEqual("0");
            });
        });

        describe("when state changes with data giving primary panel focus", function(){
            beforeEach(function(){
                state.current.data = {
                    panel: 'primary'
                };
                scope.$root.$digest();
                scope.$broadcast('$stateChangeSuccess');
            });

            it("should focus on primary panel header and update the pageService.responsive flag", function() {
                expect(focusServiceMock.focusPrimary).toHaveBeenCalled();
                expect(pageServiceMock.responsive.primary).toEqual("1");
            });
        });
    });
});